﻿$(document).on("pageinit", function () {
    SetAreaPositions();
});

$(window).on("orientationchange", function () {
    setTimeout("SetAreaPositions()", 200);
});

$(window).on("resize", function () {
    setTimeout("SetAreaPositions()", 200);
});

function SetAreaPositions() {
    $(".imageMap").each(function () {
        var imageMap = $(this);

        $("img", imageMap).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var width = image.width();
                var height = image.height();
                var borderLeftWidth = parseInt(image.css("border-left-width").replace("px", ""));
                var borderTopWidth = parseInt(image.css("border-top-width").replace("px", ""));
                var imagePosition = image.position();

                $(".area", imageMap).each(function () {
                    $(this).width(Math.min($(this).attr("data-width") * width, width));
                    $(this).height(Math.min($(this).attr("data-height") * height, height));
                    $(this).css("left", Math.ceil(($(this).attr("data-left") * width) + borderLeftWidth + imagePosition.left));
                    $(this).css("top", Math.ceil(($(this).attr("data-top") * height) + borderTopWidth + imagePosition.top));
                });
            });
        });
    });
}